const questions = [
  {
    que: "What does HTML stands for?",
    a: "Hyperlinks and Text Markup Language",
    b: "Hyper Text Markup Language",
    c: "Home Tool Markup Language",
    d: "Hyper Tool Makeup Laguage",
    correct: "b",
  },

  {
    que: "Choose the correct HTML tag for the largest heading",
    a: "<heading>",
    b: "<h6>",
    c: "<head>",
    d: "<h1>",
    correct: "d",
  },

  {
    que: "What is the correct HTML tag for inserting a line break?",
    a: "<br>",
    b: "<lb>",
    c: "</break>",
    d: "<hr>",
    correct: "a",
  },

  {
    que: "What does CSS stand for?",
    a: "Creative Style Sheets",
    b: "Cascading Style Sheets",
    c: "Computer Style Sheets",
    d: "Colorful Style Sheets",
    correct: "b",
  },

  {
    que: "Inside which HTML element do we put the JavaScript?",
    a: "<js>",
    b: "<script>",
    c: "<scripting>",
    d: "<javascript>",
    correct: "b",
  },
];

let index = 0;
let right = 0;
let wrong = 0;
let total = questions.length;
const question = document.querySelector("#quiz");
const answerInput = document.querySelectorAll(".answers");
const againBtn = document.querySelector("a");

const getAnswers = () => {
  if (index === total) {
    return endQuiz();
  }

  reset();
  let data = questions[index];
  question.innerText = `0${[index + 1]}) ${data.que}`;

  answerInput[0].nextElementSibling.innerText = data.a;
  answerInput[1].nextElementSibling.innerText = data.b;
  answerInput[2].nextElementSibling.innerText = data.c;
  answerInput[3].nextElementSibling.innerText = data.d;
};

const submitQuiz = () => {
  let data = questions[index];
  let ans = matchAns();

  if (ans === data.correct) {
    right++;
  } else {
    wrong++;
  }

  answerInput.forEach((input) => {
    if (input.checked) {
      index++;
      getAnswers();
      return;
    }
  });
};

const matchAns = () => {
  let answer;
  answerInput.forEach((input) => {
    if (input.checked) {
      answer = input.value;
    }
  });

  return answer;
};

const endQuiz = () => {
  document.getElementById("box").innerHTML = `
    <h3 class='thanks'>Thanks for playing the quiz</h3>
    <span class='score'>You scored ${right} / ${total}</span>
    <a href="">Play Again</a>
    `;
};

const reset = () => {
  answerInput.forEach((input) => {
    input.checked = false;
  });
};

getAnswers();
